/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.ExtensionFilter;
import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.TraceFileFormatType;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class TraceFileFormatAccessory
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 489900115511009984L;
    private JFileChooser aFileChooser;
    private ButtonGroup aGroup;
    private JRadioButton aHTML;
    private JRadioButton aText;
    private JRadioButton aTrace;
    private JRadioButton aEDID;

    public TraceFileFormatAccessory(JFileChooser jFileChooser, boolean bl) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder("File Type"));
        this.aFileChooser = jFileChooser;
        this.aGroup = new ButtonGroup();
        this.aHTML = new JRadioButton("HTML");
        this.aHTML.addItemListener(this);
        this.aHTML.setEnabled(bl);
        this.aHTML.setSelected(false);
        this.aText = new JRadioButton("Text");
        this.aText.addItemListener(this);
        this.aText.setEnabled(bl);
        this.aText.setSelected(false);
        this.aEDID = new JRadioButton("EDID");
        this.aEDID.addItemListener(this);
        this.aEDID.setEnabled(bl);
        this.aEDID.setSelected(false);
        this.aTrace = new JRadioButton("BMTrace");
        this.aTrace.addItemListener(this);
        this.aTrace.setEnabled(true);
        this.aTrace.setSelected(true);
        this.aGroup.add(this.aHTML);
        this.aGroup.add(this.aText);
        this.aGroup.add(this.aEDID);
        this.aGroup.add(this.aTrace);
        this.add(this.aHTML);
        this.add(this.aText);
        this.add(this.aEDID);
        this.add(this.aTrace);
    }

    public TraceFileFormatAccessory(JFileChooser jFileChooser) {
        this(jFileChooser, true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = itemEvent.getSource() == this.aHTML;
        boolean bl3 = itemEvent.getSource() == this.aText;
        boolean bl4 = itemEvent.getSource() == this.aTrace;
        boolean bl5 = bl = itemEvent.getSource() == this.aEDID;
        if (bl2 || bl3 || bl4 || bl) {
            this.setNewFileFilter(bl2, bl3, bl, bl4);
        }
    }

    public void setNewFileFilter(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        String string = "";
        String string2 = "";
        if (bl) {
            string = ".html";
            string2 = "HTML Files (" + string + ")";
            bl5 = true;
        } else if (bl2) {
            string = ".txt";
            string2 = "Text Files (" + string + ")";
            bl5 = true;
        } else if (bl3) {
            string = ".xml";
            string2 = "EDID XML Files (" + string + ")";
            bl5 = true;
        } else if (bl4) {
            string = ".BMtrace";
            string2 = "Bus Monitor Trace Files (" + string + ")";
            bl5 = true;
        }
        if (bl5) {
            this.aFileChooser.setFileFilter(new ExtensionFilter(string, string2));
            String string3 = "";
            if (this.aFileChooser.getSelectedFile() != null) {
                string3 = this.aFileChooser.getSelectedFile().getName();
                int n = string3.lastIndexOf(46);
                StringBuffer stringBuffer = new StringBuffer("");
                if (n != -1) {
                    stringBuffer.append(string3.substring(0, n) + string);
                } else {
                    stringBuffer.append("default" + string);
                }
                this.aFileChooser.setSelectedFile(new File(stringBuffer.toString()));
            } else {
                int n;
                string3 = MainAppFrame.openFile != null ? ((n = MainAppFrame.openFile.getName().lastIndexOf(46)) != -1 ? MainAppFrame.openFile.getName().substring(0, n) + string : "default" + string) : "default" + string;
                this.aFileChooser.setSelectedFile(new File(string3));
            }
        }
    }

    public void setNewFileFilter() {
        this.setNewFileFilter(this.aHTML.isSelected(), this.aText.isSelected(), this.aEDID.isSelected(), this.aTrace.isSelected());
    }

    public TraceFileFormatType GetFileFormatType() {
        TraceFileFormatType traceFileFormatType = TraceFileFormatType.BMTRACE;
        if (this.aHTML.isSelected()) {
            traceFileFormatType = TraceFileFormatType.HTML;
        } else if (this.aText.isSelected()) {
            traceFileFormatType = TraceFileFormatType.TEXT;
        } else if (this.aEDID.isSelected()) {
            traceFileFormatType = TraceFileFormatType.EDID;
        }
        return traceFileFormatType;
    }
}

